/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;

public class GenericTagUtil {
    private GenericTagUtil() {
    }

    public static <T, I extends ResourceLocation> Map<I, Set<TagKey<T>>> reverseTags(ResourceKey<? extends Registry<T>> registry, Function<T, I> keyMapper, Map<ResourceLocation, Tag<T>> tags) {
        HashMap<ResourceLocation, ImmutableSet.Builder> reverseTags = new HashMap<ResourceLocation, ImmutableSet.Builder>();
        Function<ResourceLocation, ImmutableSet.Builder> makeSet = id -> ImmutableSet.builder();
        for (Map.Entry<ResourceLocation, Tag<T>> entry2 : tags.entrySet()) {
            TagKey key = TagKey.m_203882_(registry, (ResourceLocation)entry2.getKey());
            for (Object value : entry2.getValue().m_6497_()) {
                reverseTags.computeIfAbsent((ResourceLocation)keyMapper.apply(value), makeSet).add((Object)key);
            }
        }
        return reverseTags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
    }

    public static <T> Map<ResourceLocation, Tag<T>> decodeTags(FriendlyByteBuf buf, Function<ResourceLocation, T> valueGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int mapSize = buf.m_130242_();
        for (int i = 0; i < mapSize; ++i) {
            ResourceLocation tagId = buf.m_130281_();
            int tagSize = buf.m_130242_();
            ImmutableList.Builder tagBuilder = ImmutableList.builder();
            for (int j = 0; j < tagSize; ++j) {
                tagBuilder.add(valueGetter.apply(buf.m_130281_()));
            }
            builder.put((Object)tagId, (Object)new Tag((Collection)tagBuilder.build()));
        }
        return builder.build();
    }

    public static <T> void encodeTags(FriendlyByteBuf buf, Function<T, ResourceLocation> keyGetter, Map<ResourceLocation, Tag<T>> tags) {
        buf.m_130130_(tags.size());
        for (Map.Entry<ResourceLocation, Tag<T>> entry : tags.entrySet()) {
            buf.m_130085_(entry.getKey());
            List values = entry.getValue().m_6497_();
            buf.m_130130_(values.size());
            for (Object value : values) {
                buf.m_130085_(keyGetter.apply(value));
            }
        }
    }
}

